unit OverDlg;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls, QExtCtrls, CustomRar;

type
  TOverDlg = class(TForm)
    Image1: TImage;
    Lbl: TLabel;
    SkipBtn: TButton;
    AllBtn: TButton;
    NoneBtn: TButton;
    YesBtn: TButton;
    procedure AllBtnClick(Sender: TObject);
    procedure NoneBtnClick(Sender: TObject);
    procedure SkipBtnClick(Sender: TObject);
    procedure YesBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure AfterConstruction;override;
  end;

var
  OverResult:Boolean;
  OverAll:Boolean;

implementation

{$R *.xfm}

procedure TOverDlg.AfterConstruction;
begin
  inherited;
  OverResult:=false;
  OverAll:=false;

  self.Caption:=DLG_OVER_TITLE;
  Lbl.Caption:=DLG_OVER_LABEL;
  SkipBtn.Caption:=DLG_OVER_NO;
  NoneBtn.Caption:=DLG_OVER_NONE;
  YesBtn.Caption:=DLG_OVER_YES;
  AllBtn.Caption:=DLG_OVER_ALL;
end;

procedure TOverDlg.AllBtnClick(Sender: TObject);
begin
  OverResult:=true;
  OverAll:=true;
end;

procedure TOverDlg.NoneBtnClick(Sender: TObject);
begin
  OverResult:=false;
  OverAll:=true;
end;

procedure TOverDlg.SkipBtnClick(Sender: TObject);
begin
  OverResult:=false;
  OverAll:=false;
end;

procedure TOverDlg.YesBtnClick(Sender: TObject);
begin
  OverResult:=true;
  OverAll:=false;
end;

end.
 